## Java Functions

A set of Java functions available in MDX.



### Return

```
void
```



### Description

A list of Java functions are directly available from MDX.

<b>Text :</b>

- <b>PatternMatches</b>(string regexp,string s) : equivalent to s.[matches](https://docs.oracle.com/en/java/javase/25/docs/api/java.base/java/lang/String.html#matches%28java.lang.String%29)(regexp).
- <b>Contains</b>(string s1,string s2) : equivalent to s1.[contains](https://docs.oracle.com/en/java/javase/25/docs/api/java.base/java/lang/String.html#contains%28java.lang.CharSequence%29)(s2).

PatternMatches, Contains returns false if the parameter is null.

<b>Math :</b>

- <b>IsNan</b>(double v) : equivalent to Double.[isNan](https://docs.oracle.com/en/java/javase/25/docs/api/java.base/java/lang/Double.html#isNaN%28%29)(v).
- <b>IsInfinity</b>(double v) : equivalent to Double.[isInfinity](https://docs.oracle.com/en/java/javase/25/docs/api/java.base/java/lang/Double.html#isInfinite%28%29)(v).
- <b>MaxV</b>(double v1, double v2) : equivalent to Math.[max](https://docs.oracle.com/en/java/javase/25/docs/api/java.base/java/lang/Math.html#max%28double,double%29)(v1, v2) ignoring null values.
- <b>MinV</b>(double v1, double v2) : equivalent to Math.[min](https://docs.oracle.com/en/java/javase/25/docs/api/java.base/java/lang/Math.html#min%28double,double%29)(v1, v2) ignoring null values.

IsNan and IsInfinity return false if the parameter is null.

<b>Date/Time :</b>

- <b>Today</b>() : returns the current date.
- <b>DateToString</b>(Date|DateTime date, String pattern [,String locale]) : equivalent to DateTimeFormat.forPattern(pattern).format(date). See [Java Date Format](https://docs.oracle.com/en/java/javase/25/docs/api/java.base/java/text/SimpleDateFormat.html) for more details.
- <b>StringToDate</b>(String date, String pattern [,String locale]) : equivalent to DateTimeFormat.forPattern(pattern).parseDateTime(date).toLocalDate(). See [Java Date Format](https://docs.oracle.com/en/java/javase/25/docs/api/java.base/java/text/SimpleDateFormat.html) for more details.
- <b>StringToDateTime</b>(String date, String pattern [,String locale]) : equivalent to DateTimeFormat.forPattern(pattern).parseDateTime(date).toLocalDateTime(). See [Java Date Format](https://docs.oracle.com/en/java/javase/25/docs/api/java.base/java/text/SimpleDateFormat.html) for more details.
- <b>DateTime</b>(int year, month [, day]) : returns a LocalDate using the specified parameters.
- <b>DateTime</b>(int year, month , day, hours[, minutes, seconds]) : returns a LocalDateTime using the specified parameters.

StringToDate, StringToDateTime and DateToString return null if the parameter is null.

See this [page](../mdx_types/dateandtime.md) for more details about <b>date and time</b> functions.

<b>Color :</b>

- <b>ToHexColor</b>(Number mdxColor) : converts an RGB color into a hexadecimal value.

ToHexColor returns null if the parameter is null.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### PatternMatches(regexp, string)

</div>

<div class="ic3-mdx-example-body" style="display:none">

A simple example filtering all cities containing an "ar" string

**Query**

```
Filter( [Geography].[City].members as s, PatternMatches( ".*ar.*", s.currentmember.name ) )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[City].[Caracas], 
  [Geography].[Geo].[City].[Paris], 
  [Geography].[Geo].[City].[Barcelona]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Geography].[City].[Caracas],[Geography].[City].[Paris],[Geography].[City].[Barcelona]}
```


**Assertion : MDX Equals**

```
Filter( [Geography].[City].members as s, s.currentmember.name.contains("ar") )
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Contains(string,regexp)

</div>

<div class="ic3-mdx-example-body" style="display:none">

A simple example filtering all cities containing an "ar" string

**Query**

```
Filter( [Geography].[City].members as s, s.currentmember.name.contains("ar") )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[City].[Caracas], 
  [Geography].[Geo].[City].[Paris], 
  [Geography].[Geo].[City].[Barcelona]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Geography].[City].[Caracas],[Geography].[City].[Paris],[Geography].[City].[Barcelona]}
```


**Assertion : MDX Equals**

```
Filter( [Geography].[City].members as s, PatternMatches( ".*ar.*", s.currentmember.name ) )
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### IsNan(numeric)

</div>

<div class="ic3-mdx-example-body" style="display:none">

A simple example checking if a number isNan (is not a number)

**Query**

```
WITH
    MEMBER [Measures].[isNan] AS isNaN( 0.0 / 0.0 )
SELECT
   {[Measures].[isNan]} ON 0
FROM
   [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">isNan</td>
</tr>
<tr>
 <td>true</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[isNan] AS true
SELECT
   {[Measures].[isNan]} ON 0
FROM
   [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### IsInfinity(numeric)

</div>

<div class="ic3-mdx-example-body" style="display:none">

A simple example checking if a number is infinite

**Query**

```
WITH
    MEMBER [Measures].[isNan] AS IsInfinity( 1.0 / 0.0 )
SELECT
   {[Measures].[isNan]} ON 0
FROM
   [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">isNan</td>
</tr>
<tr>
 <td>true</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[isNan] AS true
SELECT
   {[Measures].[isNan]} ON 0
FROM
   [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Today()

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the current date (without time information)

**Query**

```
Today()
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>2025-11-21</td></tr></table>


**Assertion : MDX Equals**

```
Today()
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### DateToString(date|datetime,pattern)

</div>

<div class="ic3-mdx-example-body" style="display:none">

An example to convert a date or datetime to a string using a specific format

**Query**

```
WITH
MEMBER [Measures].[isDate] AS DateToString( StringToDate("4/6/2001","d/M/yyyy"), "d MMMM yyyy" )
SELECT
{[Measures].[isDate]} ON 0
FROM
[Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">isDate</td>
</tr>
<tr>
 <td>4 June 2001</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
MEMBER [Measures].[isDate] AS "4 June 2001"
SELECT
{[Measures].[isDate]} ON 0
FROM
[Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### DateToString(date|datetime,pattern,locale)

</div>

<div class="ic3-mdx-example-body" style="display:none">

An example to convert a date or datetime to a string using a specific format and a locale

**Query**

```
WITH
MEMBER [Measures].[isDate] AS DateToString( StringToDate("4/6/2001","d/M/yyyy"), "d MMMM yyyy", "fr" )
SELECT
{[Measures].[isDate]} ON 0
FROM
[Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">isDate</td>
</tr>
<tr>
 <td>4 juin 2001</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
MEMBER [Measures].[isDate] AS "4 juin 2001"
SELECT
{[Measures].[isDate]} ON 0
FROM
[Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### StringToDate(date,pattern)

</div>

<div class="ic3-mdx-example-body" style="display:none">

An example to convert a String to a date using a specific format

**Query**

```
WITH
MEMBER [Measures].[isDate] AS StringToDate("4/6/2001","d/M/yyyy")
SELECT
{[Measures].[isDate]} ON 0
FROM
[Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">isDate</td>
</tr>
<tr>
 <td>2001-06-04</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
MEMBER [Measures].[isDate] AS StringToDate("6/4/2001","M/d/yyyy")
SELECT
{[Measures].[isDate]} ON 0
FROM
[Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### StringToDate(date,pattern,locale)

</div>

<div class="ic3-mdx-example-body" style="display:none">

An example to convert a String to a date using a specific format

**Query**

```
WITH
MEMBER [Measures].[isDate] AS StringToDate("4 Juin 2001","d MMMM yyyy", "fr")
SELECT
{[Measures].[isDate]} ON 0
FROM
[Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">isDate</td>
</tr>
<tr>
 <td>2001-06-04</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
MEMBER [Measures].[isDate] AS StringToDate("6/4/2001","M/d/yyyy")
SELECT
{[Measures].[isDate]} ON 0
FROM
[Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### StringToDateTime(date,pattern)

</div>

<div class="ic3-mdx-example-body" style="display:none">

An example to convert a String to a datetime using a specific format

**Query**

```
WITH
MEMBER [Measures].[isDate] AS StringToDateTime("4/6/2001 12","d/M/yyyy hh")
SELECT
{[Measures].[isDate]} ON 0
FROM
[Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">isDate</td>
</tr>
<tr>
 <td>2001-06-04T00:00:00.000</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
MEMBER [Measures].[isDate] AS StringToDateTime("6/4/2001:12","M/d/yyyy:hh")
SELECT
{[Measures].[isDate]} ON 0
FROM
[Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### StringToDateTime(date,pattern,locale)

</div>

<div class="ic3-mdx-example-body" style="display:none">

An example to convert a String to a datetime using a specific format and a locale.

**Query**

```
WITH
MEMBER [Measures].[isDate] AS StringToDateTime("4 Juin 2001 12","d MMMM yyyy hh", "fr")
SELECT
{[Measures].[isDate]} ON 0
FROM
[Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">isDate</td>
</tr>
<tr>
 <td>2001-06-04T00:00:00.000</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
MEMBER [Measures].[isDate] AS StringToDateTime("6/4/2001:12","M/d/yyyy:hh")
SELECT
{[Measures].[isDate]} ON 0
FROM
[Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### DateTime(year,month,day)

</div>

<div class="ic3-mdx-example-body" style="display:none">

An example how to build a date

**Query**

```
WITH
MEMBER [Measures].[isDate] AS DateTime(2001,6,4)
SELECT
{[Measures].[isDate]} ON 0
FROM
[Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">isDate</td>
</tr>
<tr>
 <td>2001-06-04</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
MEMBER [Measures].[isDate] AS StringToDate("4/6/2001","d/M/yyyy")
SELECT
{[Measures].[isDate]} ON 0
FROM
[Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### DateTime(year,month,day,hours,minutes,seconds)

</div>

<div class="ic3-mdx-example-body" style="display:none">

An example how to build a datetime

**Query**

```
WITH
MEMBER [Measures].[isDate] AS DateTime(2001,6,4,0,0)
SELECT
{[Measures].[isDate]} ON 0
FROM
[Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">isDate</td>
</tr>
<tr>
 <td>2001-06-04T00:00:00.000</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
MEMBER [Measures].[isDate] AS StringToDateTime("4/6/2001","d/M/yyyy")
SELECT
{[Measures].[isDate]} ON 0
FROM
[Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### ToHexColor(number)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Converts an RGB color into an Hexadecimal one.

**Query**

```
WITH
MEMBER [Measures].[Hexa] AS ToHexColor( RGB(16,17,18) )
SELECT
{[Measures].[Hexa]} ON 0
FROM
[Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Hexa</td>
</tr>
<tr>
 <td>#101112</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
MEMBER [Measures].[Hexa] AS "#101112"
SELECT
{[Measures].[Hexa]} ON 0
FROM
[Sales]
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### StringToDate(date,pattern) - error

</div>

<div class="ic3-mdx-example-body" style="display:none">

An example of a data pattern conversion error

**Query**

```
StringToDate("4/6/2001","d/MMM/yyyy")
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_DATE_PARSING_ERROR](icCubeError.md#olap_date_parsing_error)</td></tr><tr><td>Error Message</td><td>

StringToDate() : could not parse date '4/6/2001'. Unparseable date: "4/6/2001"</td></tr></table>


 
</div>

                                                                         

### See Also


[Excel Conversion Functions](Excel%20Conversion%20Functions.md)

[Excel Date Functions](Excel%20Date%20Functions.md)

[Excel Numerical Functions](Excel%20Numerical%20Functions.md)

[Excel Text Functions](Excel%20Text%20Functions.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
